﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.SqlClient;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.IO;
using System.Text;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager.Utilities;
using VeteransAffairs.Registries.Business.Utilities;

public partial class Surveys : BasePage
{

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            int statusId = 0;

            if (int.TryParse(Request.QueryString["statusId"], out statusId))
            {
                // Store in session
                Session["Surveys.statusId"] = SessionItemFactory.Create(statusId.ToString());
                Session["Surveys.sortColumn"] = SessionItemFactory.Create("CaseId");
                Session["Surveys.sortOrder"] = SessionItemFactory.Create("Descending");

                //check if it's in-process or completed questionnaire(now in new status)
                if (statusId == 6)
                {
                   GridViewEFRSurveys.Columns[10].Visible = false;                       
                }

                // Bind our data
                try
                {
                    GridViewEFRSurveys.DataSource = GetSurveys();  // sdr;
                    GridViewEFRSurveys.DataBind();                   
                }
                catch (Exception exc)
                { }
            }

            HiddenFieldClearFlag.Value = "0";
        }
    }

    protected void Surveys_RowDataBound(object sender, GridViewRowEventArgs e)
    {        
    }

    public void Surveys_RowCommand(object sender, GridViewCommandEventArgs e)
    {

        if (e.CommandName == "Details")
        {
            int index = Convert.ToInt32(e.CommandArgument);
            GridViewEFRSurveys.SelectedIndex = index;
            int id = Convert.ToInt32(GridViewEFRSurveys.SelectedValue);

            SurveyManager manager = new SurveyManager(); 
            WKF_CASE_ACTIVITY activity = manager.getSurveyBySurveyID(id);

            if (activity.WKF_CASE.STD_WKFCASETYPE_ID == 3) // Biomonitoring
            {
                Response.Redirect("SurveyLink.aspx?activityId={0}", id);
            }
            else if (activity.WKF_CASE.STD_WKFCASETYPE_ID == 4) // Fragment
            {
                Response.Redirect("Survey2009.aspx?activityId={0}", id);
            }
        }

        if (e.CommandName == "ViewReport")
        {
            int index = Convert.ToInt32(e.CommandArgument);
            GridViewEFRSurveys.SelectedIndex = index;
            int id = Convert.ToInt32(GridViewEFRSurveys.SelectedValue);
            
            Response.Redirect("QuestionnaireSummary.aspx?activityId={0}", id);            
        }
    }

    protected void ButtonClear_Click(object sender, EventArgs e)
    {
        TextBoxSearchCriteria.Text = String.Empty;
        HiddenFieldClearFlag.Value = "1";

        GridViewEFRSurveys.DataSource = GetSurveys();
        GridViewEFRSurveys.DataBind();  
    }

    protected void ButtonOK_Click(object sender, EventArgs e)
    {
        GridViewEFRSurveys.PageIndex = 0;
        HiddenFieldClearFlag.Value = "0";


        GridViewEFRSurveys.DataSource = GetSurveys(); 
        GridViewEFRSurveys.DataBind();  
    }

    public override string TopMenuName()
    {
        return "My Tasks";
    }

    public override string MenuItemName()
    {
        return "New";
    }

    public override string AppObjectCode()
    {
        return "EFR QUESTIONNAIRES";
    }

    public DataTable GetSurveys()
    {
        DataTable dataTable = new DataTable();
        string lastName = TextBoxSearchCriteria.Text;
        int statusId = 0;

        try
        {
            statusId = Convert.ToInt32(SessionItemValue.Get(Session["Surveys.statusId"]));
        }
        catch { }

        try
        {
            var sortColumn = SessionItemValue.Get(Session["Surveys.sortColumn"]);
            var sortOrder = SessionItemValue.Get(Session["Surveys.sortOrder"]);

            dataTable = SqlProvider.ExecuteSPDataTable(
                "RegistryConnectionString", 
                "dbo.usp_EFR_GetQuestionnaires",
                new object[] 
                { 
                    statusId,
                    2,
                    lastName,
                    sortColumn,
                    sortOrder,
                });          
        }
        catch (Exception ex)
        {
            Logging.WriteLogToFile("Error processing new referral", ex);
        }

        return dataTable;
    }
    protected void Surveys_SelectedIndexChanging(object sender, GridViewSelectEventArgs e)
    {

    }
    protected void Surveys_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        GridViewEFRSurveys.DataSource = GetSurveys();
        GridViewEFRSurveys.PageIndex = e.NewPageIndex;
        GridViewEFRSurveys.DataBind();
    }
    protected void Surveys_Sorting(object sender, GridViewSortEventArgs e)
    {
        // Sort order is always Ascending ... deal with this
        var sortOrder = SessionItemValue.Get(Session["Surveys.sortOrder"]);
        var sortColumn = SessionItemValue.Get(Session["Surveys.sortColumn"]);

        if (sortColumn == e.SortExpression && sortOrder == e.SortDirection.ToString())
        {
            if (sortOrder == "Ascending")
                Session["Surveys.sortOrder"] = SessionItemFactory.Create("Descending");
            else
                Session["Surveys.sortOrder"] = SessionItemFactory.Create("Ascending");
        }
        else
        {
            Session["Surveys.sortOrder"] = SessionItemFactory.Create(e.SortDirection.ToString());
            Session["Surveys.sortColumn"] = SessionItemFactory.Create(e.SortExpression.ToString());
        }

        GridViewEFRSurveys.DataSource = GetSurveys();
        GridViewEFRSurveys.PageIndex = 0;
        GridViewEFRSurveys.DataBind();
    }
}









